function MouseEvents(firstElemToHook) {
  if (!DebugAssert(firstElemToHook)) { return; }

  this.Initialize = function () {
      this.hookedElems = []
      this.timer = null

      this.failureEvt = {call: null, delay: 0, fired: false}
      this.onIn = {call: null, delay: 0}
      this.onOut = {call: null, delay: 0, waitFor: 'onIn'}

    this.AlsoHook(firstElemToHook);
  }

  this.AlsoHook = function (elem) {
      elem = $(elem);
    if (DebugAssert(elem)) {
      this.hookedElems.push(elem);
      this.SetHandlersFor(elem);
    }
  }

    this.SetHandlersFor = function (elem) {
      elem.onmousemove = AddChainFuncTo(elem.onmousemove,
                                        this.Method('WaitFor', 'onIn', elem));
      elem.onmouseout = AddChainFuncTo(elem.onmouseout,
                                       this.Method('WaitFor', 'onOut', elem));
    }

  this.Method = function (method_name) {
    var method = this[ method_name ];

    if (DebugAssert(typeof method == 'function')) {
      var args = this.ArgumentsToArray(arguments);
      args.shift();

      var self = this;
      return function () { return method.apply(self, args); }
    } else {
      return Function();
    }
  }

    this.ArgumentsToArray = function (argsObject) {
      return Array.prototype.slice.call(argsObject);
    }

  this.WaitFor = function (evtName, elem) {
      var event = this.GetEvent(evtName);

    switch (this.WaitStateOf(event)) {
    case 'wait':      setTimeout(this.Method('WaitFor', evtName, elem), 10);
    case 'cancelled': return;
    }

    event.fired = true;

    var delay = isset(event.delay) ? event.delay : 0;
    this.timer = RestartTimer(this.timer, this.Method('OnTimerFor', event, elem), delay);
  }

    // onmouseout might occur just before onmousemove (e.g. from another element) fires.
    this.WaitStateOf = function (event) {
      if (isset(event.waitFor)) {
          var waitForEvent = this.GetEvent(event.waitFor);

        if (isset(event.waitState)) {
          event.waitState = null;
          if (waitForEvent.fired) {
            waitForEvent.fired = false;
            return 'cancelled';
          }
        } else {
          event.waitState = 'waiting';
          waitForEvent.fired = false;
          return 'wait';
        }
      }
    }

    this.OnTimerFor = function (event, elem) {
      if (typeof event.call == 'function') {
        event.call(elem);
      }
    }

  this.GetEvent = function (evtName) {
    return DebugAssert( this[evtName] ) ? this[evtName] : this.failureEvt;
  }

  this.Initialize();
}
